; CezHalfBlocks48
;
; Derived from CezBlocks, a technique created by Metalbrain from na_th_an's idea
;
; (C) Copyright 2007-2008 ComputerEmuZone Games Studio

; Main routines of CezHalfBlocks48 technique
;
; Most comments in this file show the T-states for each instruction, since it was heavily optimized.

;**********
;dump_left: Dump buffer in left half
;**********
dump_left:	ld	bc,thebigbuffer ;10   char buffer
		ld   	e,0		; 7   starting column

putchar_left:	ld	a,(bc)		; 7
		inc	bc		; 6
		ld	d,88		; 7   attribute third
		ld	(de),a		; 7(9)(put attribute)
		ld	d,64		; 7   (1st third)
		ld   	a,(bc)   	; 7
		inc   	bc   		; 6
		ld   	l,a   		; 4
		ld   	a,(bc) 		; 7
		ld   	h,a   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
		inc     bc   		; 6
		inc   	e   		; 4
		ld	a,e		; 4
		and	16		; 7
        	jp	z,putchar_left	;10
        	ld	a,e		; 4
        	add	a,16		; 7	Jump to next line
        	ld	e,a		; 4
        	jp	nz,putchar_left	;10
putchar2_left:	ld	a,(bc)		; 7
		inc	bc		; 6
		ld	d,89		; 7   attribute third
		ld	(de),a		; 7(9)(put attribute)
		ld	d,72		; 7   (2nd third)
		ld   	a,(bc)   	; 7
		inc   	bc   		; 6
		ld   	l,a   		; 4
		ld   	a,(bc) 		; 7
		ld   	h,a   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7
		inc   	bc   		; 6
		inc   	e   		; 4
		ld	a,e		; 4
		and	16		; 7
        	jp	z,putchar2_left	;10
        	ld	a,e		; 4
        	add	a,16		; 7	Jump to next line
        	ld	e,a		; 4
        	jp	nz,putchar2_left;10
		ret

;***********
;dump_right: Dump from buffer to right half
;***********
dump_right:	ld	bc,thebigbuffer ;10   chars buffer
		ld   	e,16		; 7   starting column

putchar_right:	ld	a,(bc)		; 7
		inc	bc		; 6
		ld	d,89		; 7   attribute third
		ld	(de),a		; 7(9)(poner atributo)
		ld	d,72		; 7   (1er tercio)
		ld   	a,(bc)   	; 7
		inc   	bc   		; 6
		ld   	l,a   		; 4
		ld   	a,(bc) 		; 7
		ld   	h,a   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
		inc     bc   		; 4
		inc   	e   		; 4
		ld	a,e		; 4
		and	16		; 7
        	jp	nz,putchar_right;10
        	ld	a,e		; 4
        	add	a,16		; 7	Jump to next line
        	ld	e,a		; 4
        	cp	16		; 7	Check if we're in the last
        	jp	nz,putchar_right;10
putchar2_right:	ld	a,(bc)		; 7
		inc	bc		; 6
		ld	d,90		; 7   tercio de los atributos
		ld	(de),a		; 7(9)(poner atributo)
		ld	d,80		; 7   (2 tercio)
		ld   	a,(bc)   	; 7
		inc   	bc   		; 6
		ld   	l,a   		; 4
		ld   	a,(bc) 		; 7
		ld   	h,a   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7(9)
        	inc   	l   		; 4
        	inc   	d   		; 4
        	ld   	a,(hl)   	; 7
        	ld   	(de),a   	; 7
		inc   	bc   		; 4
		inc   	e   		; 4
		ld	a,e		; 4
		and	16		; 7
        	jp	nz,putchar2_right;10
        	ld	a,e		; 4
        	add	a,16		; 7	Jump to next line
        	ld	e,a		; 4
        	cp	16		; 7	Check if we're in the last
        	jp	nz,putchar2_right;10
		ret			;10

;Secondary routines

;Including the following changes, very specific to I NEED SPEED:
; - Only two layers (background and cars)
; - FIXED sizes 3x3 for normal sprites (car) and 8x8 for background tiles
; - Sprite structure in IX, and camera in IY. Coordinates are relative to sprite and camera positions.
; - Car graphic is always the same (but it's necessary to point to current frame)
; - A XOR is applied to the car to change the car's color accordingly, and semitransparent color is assumed
; - Number of frames if fixed at 32 for cars and 1 for backgrounds
; - Fixed number of sprites (4 cars, 9 backgrounds for each half)

;*************
; printsprite: for 3x3 graphics with transparencies, semitransparencies and independient color added
;*************
;IX > points to current car
;IY > points to current camera
;DE > points to current bufferpos

cezb_pos_x:	defb	0
cezb_pos_y:	defb	0

printsprite:	ld	l,(ix+SP_GRAPH)		 ;19 |
		ld	h,(ix+SP_GRAPH+1)	 ;19 |
		ld	a,(cezb_pos_y)		 ;10 |
		and	a			 ; 4 |
		jp	p,ps_firstnoskipline 	 ;10 |62

			;		always
			;total start > 	62

;first like skipped:
		ld	bc,9			;10 |
		add	hl,bc			;11 |
		ld	c,48			; 7 |
		ex	de,hl			; 4 |
		add	hl,bc			;11 |
		inc	a			; 4 |
		jp	z,ps_skipped1		;10 | 57
;second line skipped:
		add	hl,bc			;11 |
		ex	de,hl			; 4 |
		ld	c,9			; 7 |
		add	hl,bc			;11 |
		ld	bc,259			;10 |
		inc	a			; 4 |
		jp	z,ps_skipped		;10 | 57
		ret				;10 | 10
ps_skipped1:	ex	de,hl			; 4  |
		ld	bc,515			;10  |
		jp	ps_skipped		;10  | 24
ps_firstnoskipline:
		ld	a,d			; 4    |
		cp	(thebigbuffer/256)+3	; 7    |
		ret	nc			; 5,11 |16, 22
		
		ld	bc,771			;10    | size_y


		;		 	no skip / skip 1 / skip 2 / cut up / cut down
		;total skiplines > 	26	/     81 /    114 /    124 /       22

ps_skipped:	ld	a,(cezb_pos_x)		;10  |
		and	a			; 4  |
		jp	m,ps_left		;10  |24

		cp	16			; 7  |
		ret	nc			;5,11|12,18

		sub	14			; 7  |
		jp	p,ps_right		;10  |17

			;	       normal / left / right / skip right 
			;total line2 > 53     / 24   / 53    / 42

ps_line3:	ld	a,d			; 4  |
		cp	(thebigbuffer/256)+3	; 7  |
		ret	nc			;5,11|16,22

		push	bc			;11  |
		ld	b,c			; 4  |
		ld	c,d			; 4  |19

			;		noskip / skip down
			;total line3 > 	35     / 22

ps_char:	ld	a,(hl)			; 7  |
		and	a			; 4  |
		jp	m,ps_semitrans		;10  | 21

		jr	nz,ps_solid		;12,7| 12

						;-5
		inc	hl			; 6 |
		inc	hl			; 6 |
		inc	hl			; 6 |
		inc	de			; 6 |
		inc	de			; 6 |
		inc	de			; 4 |
		jp	ps_fromgood		;10 | 39


ps_semitrans:	ld	a,(de)			; 7 |
		and	120			; 7 |
		or	3			; 7 | 21

ps_solid:	xor	(ix+SP_COLOR)		;19 |
		ld	(de),a			; 7 |
		inc	de			; 6 |
		inc	hl			; 6 |
		ldi				;16 |
		ldi				;16 | 70

ps_fromgood:	djnz	ps_char			;13,8 | 13

			; 	       normal / semitrans / skip blank
			;total char >     116 /       125 /         87

					;-5  |
		ld	c,39		; 7  |
		ex	de,hl		; 4  |
		add	hl,bc		;11  |
		ex	de,hl		; 4  |
		pop	bc		;10  |
		djnz	ps_line3	;13,8|

			;		no skip
			;total line4 >  44

					; -5
		ret			;10
			;total end:	5

ps_left:	inc	hl			; 6  |
		inc	hl			; 6  |
		inc	hl			; 6  |
		inc	e			; 4  |
		inc	e			; 4  |
		inc	de			; 6  |
		dec	c			; 4  |
		ret	z			;11,5|47

						;-6
		inc	a			; 4  |
		jr	nz,ps_left		;12,7|10

						;-5 |

	; 	     1 skip / 2 skip / 3 skip
	;total start >  52  /    109 /    161

ps_lineleft:	ld	a,d			; 4  |
		cp	(thebigbuffer/256)+3	; 7  |
		ret	nc			;11,5|22

						;-6
		push	bc			;11  |   lines & chars left
		push	hl			;11  |   graph position
		push	de			;11  |   buffer position
		ld	b,c			; 4  |
		ld	c,d			; 4  |35
			;		noskip / skip up
			;total line3 > 	57     / 22

ps_charleft:	ld	a,(hl)			; 7 |
		and	a			; 4 |
		jp	m,ps_semitransleft	;10 | 21
		
		jr	nz,ps_solidleft		;12,7| 12
		
						;-5 |
		inc	hl			; 6 |
		inc	hl			; 6 |
		inc	hl			; 6 |
		inc	de			; 6 |
		inc	de			; 6 |
		inc	de			; 6 |
		jp	ps_nextcharleft		;10 | 41

ps_semitransleft:
		ld	a,(de)			; 7 | 
		and	120			; 7 |
		or	3			; 7 | 21

ps_solidleft:	xor	(ix+SP_COLOR)		;19 |
		ld	(de),a			; 7 |
		inc	de			; 6 |
		inc	hl			; 6 |
		ldi				;16 |
		ldi				;16 | 70

ps_nextcharleft:
		djnz	ps_charleft		;13,8|13

			; 	       noskip normal / noskip semitrans / skip blank
			;total char >  116           / 125              / 87

					; -5
		pop	hl		;10   |
		ld	c,48		; 7   |
		add	hl,bc		;11   |
		ex	de,hl		; 4   |
		pop	hl		;11   |
		ld	c,9		; 7   |
		add	hl,bc		;11   |
		pop	bc		;11   |
		djnz	ps_lineleft	;13,8 | 85

			;		no skip
			;total line4 >  85

					; -5 |
		ret			;10  | 5
			;total end: 5

ps_right:	cpl			; 4  |
		add	a,c		; 4  |
		ld	c,a		; 4  | 4    chars left in register C
		jp	ps_lineleft	;10  |18

;********
;printbg: prints all 9 backgrounds tiles in a map half
;********
;IY > points to current camera
printbg:	push	iy
		pop	ix			;points to tiles buffer in the current map position
		ld	c,3			;up to 3 lines of 8x8 blocks to be printed
		ld	e,(iy+CAM_BUFFERPOS)
		ld	d,(iy+CAM_BUFFERPOS+1)	;DE=BUFFERPOS to write to
		ld	a,(iy+CAM_INTRAX)	;get initial tile horizontal position
		ld	(cezb_pos_x),a		;set for the sprite routine
		ld	a,(iy+CAM_INTRAY)	;get initial tile vertical position
pbgouterloop:	ld	(cezb_pos_y),a		;set for the sprite routine
		ld	b,3			;up to 3 columns of 8x8 blocks to be printed
pbginnerloop:	push	bc
		push	de
		call	printsprite_bg  	;print background tile
		pop	de
		pop	bc
		ld	hl,24			;next buffer position 8 chars right
		add	hl,de
		ex	de,hl
		inc	ix
		inc	ix			;point to next map tile
		ld	a,(cezb_pos_x)
		add	a,8
		ld	(cezb_pos_x),a		;update X position for next block
		djnz	pbginnerloop		;loop for all 3 in a line
		sub	24
		ld	(cezb_pos_x),a		;update X position for next block
		ld	hl,312			; = 384-72, 384 = next buffer position 8 chars down
		add	hl,de
		ex	de,hl
		ld	a,(cezb_pos_y)
		add	a,8			;update Y position for next block
		dec	c
		jr	nz,pbgouterloop 	;repeat for 3 lines
		ret

;***************
;printsprite_bg: includes clipping, no transparencies (for backgrounds)
;***************
;DE=BUFFERPOS
;IY points to current camera
;IX points to the backgrounds buffer
printsprite_bg:	ld	l,(ix)		 	 ;19 | IX points to the backgrounds buffer
		ld	h,(ix+1)	 	 ;19 | HL = tile graph
		ld	a,(cezb_pos_y)		 ;10 |
		and	a			 ; 4 |
		jp	p,psbg_firstnoskipline 	 ;10 |  72

			;		always
			;total start > 	72

;first line, and until it stops skipping:
		ld	bc,24			;10  |
		add	hl,bc			;11  |	;add 1 line in tile
		ld	c,48			; 7  |
		ex	de,hl			; 4  |
		add	hl,bc			;11  |  
		ex	de,hl			; 4  |	;add 1 line in buffer
		ld	bc,1800			;10  |54 ; B=7,C=8

psbg_line5:	inc	a                       ; 4  |
		jr	z,psbg_firstnoskipline2 ;12,7|16

						;-5
		push	bc			;11  |
		ld	bc,48			;10  |
		ex	de,hl			; 4  |
		add	hl,bc			;11  |
		ex	de,hl			; 4  |	;add 1 line in buffer
		ld	c,24			; 7  |
		add	hl,bc			;11  |	;add 1 line in tile
		pop	bc			;10  |
		djnz	psbg_line5		;13,8|76 ;update B

			;	        no skip / skip up
			;total line 1:  16      / 92

					; -5
		ret			;10		;return if we're above the buffer
			;total end:	 5

psbg_firstnoskipline:
		ld	a,d			; 4    | 
		cp	(thebigbuffer/256)+3	; 7    |
		ret	nc			; 5,11 |16,22	;Return if we're below the buffer
		ld	bc,2056			;10    | ; B=8,C=8
		
psbg_firstnoskipline2:
		ld	a,(cezb_pos_x)		;10  |
		and	a			; 4  |
		jp	m,psbg_left		;10  |39 ;if position is negative, go to cut characters in the left side

		cp	16			; 7  |
		ret	nc			;11,5|18 ;if position is above 16, return because it's at the right of the visible zone

						;-6
		sub	9			; 7  |
		jp	p,psbg_right		;10  |11 ;if the sprite doesn't fit, go to cut characters in the right side


			;		normal  / left   / right    / skip down / skip right 
			;total line2 > 	 86(70) / 67(39) /  98 (70) / 22        / 86(58)

psbg_line3:	ld	a,d			; 4  |
		cp	(thebigbuffer/256)+3	; 7  |
		ret	nc			;11,5|22 ;Return if we're below the buffer

						;-6  |
		push	bc			;11  |
		ld	b,c			; 4  |
		ld	c,d			; 4  |13 ;set C higher than 3*8 (we're sure D is), because ldi will decrease BC, and we don't want it touching B
			;		noskip / skip up
			;total line3 > 	35     / 22

psbg_char:	ldi				;16  |
		ldi				;16  |
		ldi				;16  |	 ;copy bytes from background tile to buffer
		djnz	psbg_char		;13,8|61 ;repeat for all columns
							
			; 	       noskip
			;total char >  61

					; -5 |
		ld	c,24		; 7  |
		ex	de,hl		; 4  |
		add	hl,bc		;11  |	
		ex	de,hl		; 4  |	;Point to next line in buffer
		pop	bc		;10  |
		djnz	psbg_line3	;13,8|44 ;Next line

			;		no skip
			;total line4 >  44

					; -5
		ret			;10		;End
			;total end:	5

psbg_left:	inc	hl			; 6  |
		inc	hl			; 6  |
		inc	hl			; 6  |
		inc	e			; 4  |
		inc	de			; 6  |
		inc	de			; 6  |
		dec	c			; 4  |	; decrease number of characters
		ret	z			;11,5| 49 ; return if we're completely at the left of buffer
		
						;-6  |
		inc	a			; 4  | ; increase position
		jr	nz,psbg_left		;12,7| 10 ;keep doing it until position is 0

						;-5  |
			;	      last / skip / final
			;total char >  54  /  59  /    49

psbg_lineleft:
		ld	a,d			; 4  |
		cp	(thebigbuffer/256)+3	; 7  |
		ret	nc			;11,5|22 ;Return if we're below the buffer

						;-6  |
		push	bc			;11  |   keep number of lines and characters
		push	hl			;11  |   graph position
		push	de			;11  |   buffer position
		ld	b,c			; 4  |   number of characters in B
		ld	c,d			; 7  |35 ;set C higher than 3*7 (we're sure D is), because ldi will decrease BC, and we don't want it touching B
			;		noskip / skip up
			;total line3 >  57     / 22

psbg_charleft:	ldi				;16  |
		ldi				;16  |
		ldi				;16  |   ;copy bytes from background tile to buffer
		djnz	psbg_charleft		;13,8|61 ;repeat for all visible columns

			; 	       noskip
			;total char >  61

					; -5  |
		pop	hl		;10   | ; restore buffer position
		ld	c,48		; 7   |
		add	hl,bc		;11   |
		ex	de,hl		; 4   | ; Advance a buffer line
		pop	hl		;10   | ; restore graph position
		ld	c,24		; 7   |
		add	hl,bc		;11   |	; Advance a tile line
		pop	bc		;10   | ; Restore number of lines
		djnz	psbg_lineleft	;13,8 |78 ;Repeat for all lines

			;		no skip
			;total line2 >  78

					; -5
		ret			;10
			;total end: 5

psbg_right:	cpl				; 4  |
		add	a,c			; 4  |
		ld	c,a			; 4  |   ; get number of visible characters
		jp	psbg_lineleft		;10  |22 ; right side is printed the same way as left


;**********
;printcars: print all cars in current camera
;**********
;IY = camera pointer
printcars:	ld	ix,car1			;First car
		ld	b,4			;Number of cars
pc_loop:	bit	4,(ix+SP_STATE)
		jp	nz,pc_noprint		;If the car doesn't race, don't print it
		ld	a,(ix+SP_MAPX)
		inc	a
		sub	(iy+CAM_MAPX)
		and	63
		cp	4
		jr	nc,pc_noprint		;If horizontal position if far, don't print this car
		ld	e,a
		ld	a,(ix+SP_MAPY)
		inc	a
		sub	(iy+CAM_MAPY)
		and	63
		cp	4
		jr	nc,pc_noprint		;If vertical position if far, don't print this car
		dec	a
		add	a,a
		add	a,a
		add	a,a
		add	a,(iy+CAM_INTRAY)
		add	a,(ix+SP_INTRAY)
		ld	(cezb_pos_y),a		;Store vertical position
		ld	d,a
		ld	a,e
		dec	a
		add	a,a
		add	a,a
		add	a,a
		add	a,(iy+CAM_INTRAX)
		add	a,(ix+SP_INTRAX)
		ld	(cezb_pos_x),a		;Store horizontal position
		ld	e,a
		ld	a,(iy+CAM_CAR)
		cp	(ix+SP_CAMERA)
		jr	nz,pc_nocamera
		ld	(iy+CAM_POSX),e
		ld	(iy+CAM_POSY),d		;If this is the main car pointed by the camera, store its position in the camera variables
pc_nocamera:	ld	a,e
		push	bc			;Keep BC for later
		ld	bc,0
		and	a
		jp	p,pc_nosignex		
		dec	b			;B=255 if E is negative
pc_nosignex:	sra	d
		rr	c
		sra	d
		rr	c
		sra	d
		rr	c
		sra	d
		rr	c			;DC==y*16, sign extended
		add	a,c			;add C to E
		ld	e,a
		ld	a,d
		adc	a,b			;extend carry to D
		ld	d,a			;DE=y*16+x
		ld	hl,thebigbuffer
		add	hl,de
		add	hl,de
		add	hl,de			;HL=thebigbuffer+3*(y*16+x)
		ex	de,hl
		call	printsprite		;Print the car
		pop	bc
pc_noprint:	ld	de,car2-car1
		add	ix,de			;Point to next car
		djnz	pc_loop			;Loop for all cars
		ret

;**********		
;inc2frame: advance 2 frames
;**********
inc2frame:	ld	de,54			;Graphic advance
		ld	a,(ix+SP_FRAME)		;Get current frame
		add	a,2			;Increase it
		cp	32			;Check if we've passed the end
		jr	c,inc2frame_doit
		sub	32			;In that case, go back
		ld	de,-810			;New graphic advance
inc2frame_doit:	ld	(ix+SP_FRAME),a		;Update frame
inc2frame_doit2:ld	h,(ix+SP_GRAPH+1)
		ld	l,(ix+SP_GRAPH)
		add	hl,de
		ld	(ix+SP_GRAPH+1),h
		ld	(ix+SP_GRAPH),l		;Update graphic pointer for the car
		ret

;**********
;dec2frame: decrease 2 frames
;**********
dec2frame:	ld	de,-54			;Graphic advance
		ld	a,(ix+SP_FRAME)		;Get current frame
		dec	a
		dec	a			;Decrease it
		jp	p,inc2frame_doit	;Check if we've passed the start
		add	a,32			;In that case, advance to the last
		ld	de,810			;New graphic advance
		jr	inc2frame_doit

;**********
;movetyres: move tyres of the car, changing the bit 0 in the frame variable
;**********
movetyres:	bit	0,(ix+SP_FRAME)		;Get frame's bit 0
		jr	nz,decframe		;If it's 1, decrease it
						;Otherwise increase it

;*********
;incframe: increase 1 frame. Wraparound not tested.
;*********
incframe:	ld	de,27			;Graphic advance
		set	0,(ix+SP_FRAME)		;Increase frame
		jr	inc2frame_doit2

;*********
;decframe: decrease 1 frame. Wraparound not tested.
;*********
decframe:	ld	de,-27			;Graphic advance
		res	0,(ix+SP_FRAME)		;Decrease frame
		jr	inc2frame_doit2

;*****
;incx: increase x position
;*****
incx:		ld	a,(ix+SP_INTRAX)	;19  | 		Get INTRAX value
		inc	a			; 4  |		Increase it
		and	7			; 7  |		Keep it in 0-7 range
		ld	(ix+SP_INTRAX),a	;19  |		Update it
		ret	nz			;11,5|60 	If it's not 0, return
						;-6 |		If it's 0, we must increase MAPX
		ld	a,(ix+SP_MAPX)		;19 |		Get MAPX value
		inc	a			; 4 |		Increase it
		and	63			; 7 |		Keep it in 0-63 range
		ld	(ix+SP_MAPX),a		;19 |		Update it
incx_nomap:	ret				;10 | 53

;*****		
;decx: decrease x position
;*****
decx:		ld	a,(ix+SP_INTRAX) ;Get INTRAX value
		dec	a		 ;Decrease it
		jp	p,decx_nomap
					 ;If it becomes negative
		ld	a,(ix+SP_MAPX)   ;Get MAPX
		dec	a		 ;Decrease it
		and	63		 ;Keep it in 0-63 range
		ld	(ix+SP_MAPX),a	 ;Update it
		ld	a,7		 ;Value 7 for INTRAX
decx_nomap:	ld	(ix+SP_INTRAX),a ;Update it
		ret

;*****
;incy: increase y position
;*****
incy:		ld	a,(ix+SP_INTRAY)	;19  | 		Get INTRAY value
		inc	a			; 4  |		Increase it
		and	7			; 7  |		Keep it in 0-7 range
		ld	(ix+SP_INTRAY),a	;19  |		Update it
		ret	nz			;11,5|60	If it's not 0, return
						;-6 |		If it's 0, we must increase MAPY
		ld	a,(ix+SP_MAPY)		;19 |		Get MAPY value
		inc	a			; 4 |		Increase it
		and	63			; 7 |		Keep it in 0-63 range
		ld	(ix+SP_MAPY),a		;19 |		Update it
incy_nomap:	ret				;10 | 53

;*****
;decy: decrease y position
;*****
decy:		ld	a,(ix+SP_INTRAY) ;Get INTRAY value
		dec	a		 ;Decrease it
		jp	p,decy_nomap	 
					 ;If it becomes negative
		ld	a,(ix+SP_MAPY)   ;Get MAPY
		dec	a		 ;Decrease it
		and	63		 ;Keep it in 0-63 range
		ld	(ix+SP_MAPY),a	 ;Update it
		ld	a,7		 ;Value 7 for INTRAY
decy_nomap:	ld	(ix+SP_INTRAY),a ;Update it
		ret
